# Getting started
load("admcycles.sage")

# Entering tautological classes - combinations of divisors
t1=3*sepbdiv(1,(1,2),3,4)-psiclass(4,3,4)^2  # classes live on \Mbar_{3,4}
g=2;n=1;
t2=-1/3*irrbdiv()*lambdaclass(1) # classes live on \Mbar_{2,1}

# Entering tautological classes - listing generators in given degree
list_tautgens(2,0,2) #generators of R^2(\Mbar_{2,0})
L=tautgens(2,0,2);
t3=2*L[3]+L[4]
t3

# Entering a stable graph manually
stgraph([1,1],[[2],[3]],[(2,3)]) # graph has two genus 1 components, connected by an edge

# Basic operations with tautclasses
s1=psiclass(3,1,3)^2 # psi_3 on \Mbar_{1,3}
s1.forgetful_pushforward([3]) # pi_* (psi_3) under map pi: \Mbar_{1,3} -> \Mbar_{1,2} forgetting marking 3

s2=psiclass(2,1,2)
s2.forgetful_pullback([3]) # pi^* (psi_2) under map pi: \Mbar_{1,3} -> \Mbar_{1,2}

s3=psiclass(2,1,3)*psiclass(3,1,3)^2
s3.evaluate() # compute the degree of the zero cycle s3=psi_2*(psi_3)^2 on \Mbar_{1,3}

s4=psiclass(2,1,2)^2+psiclass(1,1,2)*psiclass(2,1,2)
s4.evaluate()

# A basis of the tautological ring and tautological relations
generating_indices(2,0,2) # gives list of indices of tautgens(2,0,2) forming a basis of R^2(\Mbar_{2,0})
t3.toTautbasis(2,0,2) # expresses class t3 in terms of this basis

# Verifying the divisor relation kappa - psi + delta_0 on \bar M_{1,4}
g=1;n=4;
bgraphs=[bd for bd in list_strata(g,n,1) if bd.numvert()>1]
del0=sum([bd.to_tautclass() for bd in bgraphs]) # sum of boundary classes with separating node
psisum=sum([psiclass(i) for i in range(1,n+1)]) # sum of psi-classes
rel=kappaclass(1)-psisum+del0
rel.is_zero()

# Pulling back tautological classes to a boundary divisor
bdry=stgraph([2,2],[[1],[2]],[(1,2)])
generator=tautgens(4,0,2)[3]; generator
pullback=bdry.boundary_pullback(generator); 
pullback.totensorTautbasis(2)
pullback.totensorTautbasis(2,vecout=true)

# Computing the cycle of the hyperelliptic locus in genus 3
H=Hyperell(3,0,0) 
# the cycle of hyperell. curves of genus 3 with 0 marked fixed points of the involution and 0 marked pairs of conjugate points
H.toTautbasis()
# we compare with the known expression H=9*lambda-delta_0-3*delta_1
g=3; n=0;
H2=9*lambdaclass(1)-(1/2)*irrbdiv()-3*sepbdiv(1,())
H2.toTautbasis()


# Specifying Hurwitz cycles
G=PermutationGroup([(1,2)]) # G=Z/2Z
H=HurData(G,[G[1],G[1]]) # this means there are two ramification points with stabilizer generated by G[1], the generator of G

vbeta=Hidentify(2,H,vecout=true) # identify the locus of bielliptic curves (C,p,q) with marked ramification points p,q in \Mbar_{2,2} in terms of the generating set tautgens(2,2,3) of R^3(\Mbar_{2,2})
vector(vbeta)

H2=HurData(G,[G[1],G[1],G[0]])

G=PermutationGroup([(1,2)])
H=HurData(G,[G[1],G[1]])
Biell=Hidentify(2,H,markings=[]) # identify the locus of bielliptic curves C, remembering none of the marked ramification points, inside \Mbar_{2,0}
Biell.toTautbasis(2,0,1) # represent it in the basis of R^1(\Mbar_{2,0})

g=2;n=0
Biell2=3/4*irrbdiv()+ 3*sepbdiv(1,()) # this is the formula for the bielliptic locus known from the literature
Biell2.toTautbasis(2,0,1)

# Computing the Hurwitz Hodge integral \int_[\bar B_{2,2,0}] lambda_2
(Biell*lambdaclass(2,2,0)).evaluate() # = 1/48
